// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

package org.chromium.chrome.test.util.browser;

import org.chromium.chrome.browser.tab.Tab;
import org.chromium.net.test.EmbeddedTestServer;

/**
 * Computes URL of webapp test pages with the passed in Web Manifest URL.
 */
public class WebappTestPage {
    /**
     * Title of pages whose URL was generated by {@link #urlOfPageWithServiceWorkerAndManifest()}.
     */
    public static final String TITLE = "Web app banner test page";

    /**
     * Computes URL of page which is controlled by a service worker and uses the passed in Web
     * Manifest URL.
     */
    public static String urlOfPageWithServiceWorkerAndManifest(
            EmbeddedTestServer testServer, String manifestUrl) {
        String url = "/chrome/test/data/banners/manifest_test_page.html?manifest=" + manifestUrl;
        return testServer.getURL(url);
    }

    /**
     * Navigates to page which is controlled by a service worker and uses the passed in Web Manifest
     * URL.
     */
    public static void navigateToPageWithServiceWorkerAndManifest(
            EmbeddedTestServer testServer, Tab tab, String manifestUrl) throws Exception {
        TabLoadObserver observer = new TabLoadObserver(tab, TITLE, null);
        observer.fullyLoadUrl(urlOfPageWithServiceWorkerAndManifest(testServer, manifestUrl));
    }
}
