/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.zip.Inflater;

class VncCanvas
extends Canvas
implements KeyListener,
MouseListener,
MouseMotionListener {
    VncViewer viewer;
    RfbProto rfb;
    ColorModel cm8_256c;
    ColorModel cm8_64c;
    ColorModel cm8_8c;
    ColorModel cm24;
    Color[] colors;
    int bytesPixel;
    Image memImage;
    Graphics memGraphics;
    Image rawPixelsImage;
    MemoryImageSource pixelsSource;
    byte[] pixels8;
    int[] pixels24;
    byte[] zlibBuf;
    int zlibBufLen = 0;
    Inflater zlibInflater;
    static final int tightZlibBufferSize = 512;
    Inflater[] tightInflaters;
    Rectangle jpegRect;
    boolean inputEnabled;
    private Color hextile_bg;
    private Color hextile_fg;
    boolean showSoftCursor = false;
    int[] softCursorPixels;
    MemoryImageSource softCursorSource;
    Image softCursor;
    int cursorX = 0;
    int cursorY = 0;
    int cursorWidth;
    int cursorHeight;
    int hotX;
    int hotY;

    VncCanvas(VncViewer vncViewer) throws IOException {
        this.viewer = vncViewer;
        this.rfb = this.viewer.rfb;
        this.tightInflaters = new Inflater[4];
        this.cm8_256c = new DirectColorModel(8, 7, 56, 192);
        this.cm8_64c = new DirectColorModel(8, 48, 12, 3);
        this.cm8_8c = new DirectColorModel(8, 4, 2, 1);
        this.cm24 = new DirectColorModel(24, 0xFF0000, 65280, 255);
        this.colors = new Color[256];
        int n = 0;
        while (n < 256) {
            this.colors[n] = new Color(this.cm8_256c.getRGB(n));
            ++n;
        }
        this.setPixelFormat();
        this.inputEnabled = false;
        if (!this.viewer.options.viewOnly) {
            this.enableInput(true);
        }
        this.addKeyListener(this);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.rfb.framebufferWidth, this.rfb.framebufferHeight);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.rfb.framebufferWidth, this.rfb.framebufferHeight);
    }

    public Dimension getMaximumSize() {
        return new Dimension(this.rfb.framebufferWidth, this.rfb.framebufferHeight);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        Rectangle rectangle;
        Image image = this.memImage;
        synchronized (image) {
            graphics.drawImage(this.memImage, 0, 0, null);
        }
        if (this.showSoftCursor && (rectangle = new Rectangle(n2 = this.cursorX - this.hotX, n = this.cursorY - this.hotY, this.cursorWidth, this.cursorHeight)).intersects(graphics.getClipBounds())) {
            graphics.drawImage(this.softCursor, n2, n, null);
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0xA0) == 0) {
            return true;
        }
        if ((n & 0x20) != 0 && this.jpegRect != null) {
            Rectangle rectangle = this.jpegRect;
            synchronized (rectangle) {
                this.memGraphics.drawImage(image, this.jpegRect.x, this.jpegRect.y, null);
                this.scheduleRepaint(this.jpegRect.x, this.jpegRect.y, this.jpegRect.width, this.jpegRect.height);
                this.jpegRect.notify();
            }
        }
        return false;
    }

    public synchronized void enableInput(boolean bl) {
        if (bl && !this.inputEnabled) {
            this.inputEnabled = true;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            if (this.viewer.showControls) {
                this.viewer.buttonPanel.enableRemoteAccessControls(true);
            }
        } else if (!bl && this.inputEnabled) {
            this.inputEnabled = false;
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
            if (this.viewer.showControls) {
                this.viewer.buttonPanel.enableRemoteAccessControls(false);
            }
        }
    }

    public void setPixelFormat() throws IOException {
        if (this.viewer.options.eightBitColors > 0) {
            this.viewer.options.oldEightBitColors = this.viewer.options.eightBitColors;
            switch (this.viewer.options.eightBitColors) {
                case 1: {
                    int n = 0;
                    while (n < 256) {
                        this.colors[n] = new Color(this.cm8_256c.getRGB(n));
                        ++n;
                    }
                    this.rfb.writeSetPixelFormat(8, 8, false, true, 7, 7, 3, 0, 3, 6, false);
                    break;
                }
                case 2: {
                    int n = 0;
                    while (n < 256) {
                        this.colors[n] = new Color(this.cm8_64c.getRGB(n));
                        ++n;
                    }
                    this.rfb.writeSetPixelFormat(8, 6, false, true, 3, 3, 3, 4, 2, 0, false);
                    break;
                }
                case 3: {
                    int n = 0;
                    while (n < 256) {
                        this.colors[n] = new Color(this.cm8_8c.getRGB(n));
                        ++n;
                    }
                    this.rfb.writeSetPixelFormat(8, 3, false, true, 1, 1, 1, 2, 1, 0, false);
                    break;
                }
                case 4: {
                    int n = 0;
                    while (n < 256) {
                        this.colors[n] = new Color(this.cm8_64c.getRGB(n));
                        ++n;
                    }
                    this.rfb.writeSetPixelFormat(8, 6, false, true, 3, 3, 3, 4, 2, 0, true);
                    break;
                }
                case 5: {
                    int n = 0;
                    while (n < 256) {
                        this.colors[n] = new Color(this.cm8_8c.getRGB(n));
                        ++n;
                    }
                    this.rfb.writeSetPixelFormat(8, 3, false, true, 1, 1, 1, 2, 1, 0, true);
                }
            }
            this.bytesPixel = 1;
        } else {
            this.rfb.writeSetPixelFormat(32, 24, false, true, 255, 255, 255, 16, 8, 0, false);
            this.bytesPixel = 4;
        }
        this.updateFramebufferSize();
    }

    void updateFramebufferSize() {
        Object object;
        int n = this.rfb.framebufferWidth;
        int n2 = this.rfb.framebufferHeight;
        if (this.memImage == null) {
            this.memImage = this.viewer.createImage(n, n2);
            this.memGraphics = this.memImage.getGraphics();
        } else if (this.memImage.getWidth(null) != n || this.memImage.getHeight(null) != n2) {
            object = this.memImage;
            synchronized (object) {
                this.memImage = this.viewer.createImage(n, n2);
                this.memGraphics = this.memImage.getGraphics();
            }
        }
        if (this.bytesPixel == 1) {
            this.pixels24 = null;
            this.pixels8 = new byte[n * n2];
            object = this.cm8_8c;
            switch (this.viewer.options.eightBitColors) {
                case 1: {
                    object = this.cm8_256c;
                    break;
                }
                case 2: 
                case 4: {
                    object = this.cm8_64c;
                    break;
                }
                case 3: 
                case 5: {
                    object = this.cm8_8c;
                }
            }
            this.pixelsSource = new MemoryImageSource(n, n2, (ColorModel)object, this.pixels8, 0, n);
        } else {
            this.pixels8 = null;
            this.pixels24 = new int[n * n2];
            this.pixelsSource = new MemoryImageSource(n, n2, this.cm24, this.pixels24, 0, n);
        }
        this.pixelsSource.setAnimated(true);
        this.rawPixelsImage = this.createImage(this.pixelsSource);
        if (this.viewer.inSeparateFrame) {
            if (this.viewer.desktopScrollPane != null) {
                this.resizeDesktopFrame();
            }
        } else {
            this.setSize(n, n2);
        }
    }

    void resizeDesktopFrame() {
        Dimension dimension;
        this.setSize(this.rfb.framebufferWidth, this.rfb.framebufferHeight);
        Insets insets = this.viewer.desktopScrollPane.getInsets();
        this.viewer.desktopScrollPane.setSize(this.rfb.framebufferWidth + 2 * Math.min(insets.left, insets.right), this.rfb.framebufferHeight + 2 * Math.min(insets.top, insets.bottom));
        this.viewer.vncFrame.pack();
        Dimension dimension2 = this.viewer.vncFrame.getToolkit().getScreenSize();
        Dimension dimension3 = dimension = this.viewer.vncFrame.getSize();
        boolean bl = false;
        if (dimension.height > dimension2.height) {
            dimension3.height = dimension2.height;
            bl = true;
        }
        if (dimension.width > dimension2.width) {
            dimension3.width = dimension2.width;
            bl = true;
        }
        if (bl) {
            ((Component)this.viewer.vncFrame).setSize(dimension3);
        }
        this.viewer.desktopScrollPane.doLayout();
    }

    /*
     * Unable to fully structure code
     */
    public void processNormalProtocol() throws Exception {
        this.viewer.checkRecordingStatus();
        this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight, false);
        block22: while (true) {
            var1_1 = this.rfb.readServerMessageType();
            switch (var1_1) {
                case 0: {
                    this.rfb.readFramebufferUpdate();
                    var2_2 = 0;
                    while (var2_2 < this.rfb.updateNRects) {
                        this.rfb.readFramebufferUpdateRectHdr();
                        var3_3 = this.rfb.updateRectX;
                        var4_4 = this.rfb.updateRectY;
                        var5_7 = this.rfb.updateRectW;
                        var6_9 = this.rfb.updateRectH;
                        if (this.rfb.updateRectEncoding == -224) break;
                        if (this.rfb.updateRectEncoding == -223) {
                            this.rfb.setFramebufferSize(var5_7, var6_9);
                            this.updateFramebufferSize();
                            break;
                        }
                        if (this.rfb.updateRectEncoding == -240) ** GOTO lbl-1000
                        if (this.rfb.updateRectEncoding == -239) lbl-1000:
                        // 2 sources

                        {
                            this.handleCursorShapeUpdate(this.rfb.updateRectEncoding, var3_3, var4_4, var5_7, var6_9);
                        } else {
                            switch (this.rfb.updateRectEncoding) {
                                case 0: {
                                    this.handleRawRect(var3_3, var4_4, var5_7, var6_9);
                                    break;
                                }
                                case 1: {
                                    this.handleCopyRect(var3_3, var4_4, var5_7, var6_9);
                                    break;
                                }
                                case 2: {
                                    this.handleRRERect(var3_3, var4_4, var5_7, var6_9);
                                    break;
                                }
                                case 4: {
                                    this.handleCoRRERect(var3_3, var4_4, var5_7, var6_9);
                                    break;
                                }
                                case 5: {
                                    this.handleHextileRect(var3_3, var4_4, var5_7, var6_9);
                                    break;
                                }
                                case 6: {
                                    this.handleZlibRect(var3_3, var4_4, var5_7, var6_9);
                                    break;
                                }
                                case 7: {
                                    this.handleTightRect(var3_3, var4_4, var5_7, var6_9);
                                    break;
                                }
                                case -232: {
                                    this.handleCursorPosUpdate(var3_3, var4_4);
                                    break;
                                }
                                default: {
                                    throw new Exception("Unknown RFB rectangle encoding " + this.rfb.updateRectEncoding);
                                }
                            }
                        }
                        ++var2_2;
                    }
                    var3_3 = 0;
                    if (this.viewer.checkRecordingStatus()) {
                        var3_3 = 1;
                    }
                    if (this.viewer.deferUpdateRequests > 0) {
                        var4_5 = this.rfb;
                        synchronized (var4_5) {
                            try {
                                this.rfb.wait(this.viewer.deferUpdateRequests);
                            }
                            catch (InterruptedException var5_8) {
                                // empty catch block
                            }
                        }
                    }
                    if (this.viewer.options.eightBitColors > 0 && this.bytesPixel != 1 || this.viewer.options.eightBitColors == 0 && this.bytesPixel == 1 || this.viewer.options.eightBitColors != this.viewer.options.oldEightBitColors) {
                        this.setPixelFormat();
                        var3_3 = 1;
                    }
                    this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight, var3_3 == 0);
                    continue block22;
                }
                case 1: {
                    throw new Exception("Can't handle SetColourMapEntries message");
                }
                case 2: {
                    Toolkit.getDefaultToolkit().beep();
                    continue block22;
                }
                case 3: {
                    var4_6 = this.rfb.readServerCutText();
                    this.viewer.clipboard.setCutText(var4_6);
                    continue block22;
                }
                case 7: {
                    this.viewer.rfb.readRfbFileTransferMsg();
                    continue block22;
                }
            }
            break;
        }
        throw new Exception("Unknown RFB message type " + var1_1);
    }

    void handleRawRect(int n, int n2, int n3, int n4) throws IOException {
        this.handleRawRect(n, n2, n3, n4, true);
    }

    void handleRawRect(int n, int n2, int n3, int n4, boolean bl) throws IOException {
        if (this.bytesPixel == 1) {
            int n5 = n2;
            while (n5 < n2 + n4) {
                this.rfb.is.readFully(this.pixels8, n5 * this.rfb.framebufferWidth + n, n3);
                if (this.rfb.rec != null) {
                    this.rfb.rec.write(this.pixels8, n5 * this.rfb.framebufferWidth + n, n3);
                }
                ++n5;
            }
        } else {
            byte[] byArray = new byte[n3 * 4];
            int n6 = n2;
            while (n6 < n2 + n4) {
                this.rfb.is.readFully(byArray);
                if (this.rfb.rec != null) {
                    this.rfb.rec.write(byArray);
                }
                int n7 = n6 * this.rfb.framebufferWidth + n;
                int n8 = 0;
                while (n8 < n3) {
                    this.pixels24[n7 + n8] = (byArray[n8 * 4 + 2] & 0xFF) << 16 | (byArray[n8 * 4 + 1] & 0xFF) << 8 | byArray[n8 * 4] & 0xFF;
                    ++n8;
                }
                ++n6;
            }
        }
        this.handleUpdatedPixels(n, n2, n3, n4);
        if (bl) {
            this.scheduleRepaint(n, n2, n3, n4);
        }
    }

    void handleCopyRect(int n, int n2, int n3, int n4) throws IOException {
        this.rfb.readCopyRect();
        this.memGraphics.copyArea(this.rfb.copyRectSrcX, this.rfb.copyRectSrcY, n3, n4, n - this.rfb.copyRectSrcX, n2 - this.rfb.copyRectSrcY);
        this.scheduleRepaint(n, n2, n3, n4);
    }

    void handleRRERect(int n, int n2, int n3, int n4) throws IOException {
        int n5 = this.rfb.is.readInt();
        byte[] byArray = new byte[this.bytesPixel];
        this.rfb.is.readFully(byArray);
        Color color = this.bytesPixel == 1 ? this.colors[byArray[0] & 0xFF] : new Color(byArray[2] & 0xFF, byArray[1] & 0xFF, byArray[0] & 0xFF);
        this.memGraphics.setColor(color);
        this.memGraphics.fillRect(n, n2, n3, n4);
        byte[] byArray2 = new byte[n5 * (this.bytesPixel + 8)];
        this.rfb.is.readFully(byArray2);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray2));
        if (this.rfb.rec != null) {
            this.rfb.rec.writeIntBE(n5);
            this.rfb.rec.write(byArray);
            this.rfb.rec.write(byArray2);
        }
        int n6 = 0;
        while (n6 < n5) {
            if (this.bytesPixel == 1) {
                color = this.colors[dataInputStream.readUnsignedByte()];
            } else {
                dataInputStream.skip(4L);
                color = new Color(byArray2[n6 * 12 + 2] & 0xFF, byArray2[n6 * 12 + 1] & 0xFF, byArray2[n6 * 12] & 0xFF);
            }
            int n7 = n + dataInputStream.readUnsignedShort();
            int n8 = n2 + dataInputStream.readUnsignedShort();
            int n9 = dataInputStream.readUnsignedShort();
            int n10 = dataInputStream.readUnsignedShort();
            this.memGraphics.setColor(color);
            this.memGraphics.fillRect(n7, n8, n9, n10);
            ++n6;
        }
        this.scheduleRepaint(n, n2, n3, n4);
    }

    void handleCoRRERect(int n, int n2, int n3, int n4) throws IOException {
        int n5 = this.rfb.is.readInt();
        byte[] byArray = new byte[this.bytesPixel];
        this.rfb.is.readFully(byArray);
        Color color = this.bytesPixel == 1 ? this.colors[byArray[0] & 0xFF] : new Color(byArray[2] & 0xFF, byArray[1] & 0xFF, byArray[0] & 0xFF);
        this.memGraphics.setColor(color);
        this.memGraphics.fillRect(n, n2, n3, n4);
        byte[] byArray2 = new byte[n5 * (this.bytesPixel + 4)];
        this.rfb.is.readFully(byArray2);
        if (this.rfb.rec != null) {
            this.rfb.rec.writeIntBE(n5);
            this.rfb.rec.write(byArray);
            this.rfb.rec.write(byArray2);
        }
        int n6 = 0;
        int n7 = 0;
        while (n7 < n5) {
            if (this.bytesPixel == 1) {
                color = this.colors[byArray2[n6++] & 0xFF];
            } else {
                color = new Color(byArray2[n6 + 2] & 0xFF, byArray2[n6 + 1] & 0xFF, byArray2[n6] & 0xFF);
                n6 += 4;
            }
            int n8 = n + (byArray2[n6++] & 0xFF);
            int n9 = n2 + (byArray2[n6++] & 0xFF);
            int n10 = byArray2[n6++] & 0xFF;
            int n11 = byArray2[n6++] & 0xFF;
            this.memGraphics.setColor(color);
            this.memGraphics.fillRect(n8, n9, n10, n11);
            ++n7;
        }
        this.scheduleRepaint(n, n2, n3, n4);
    }

    void handleHextileRect(int n, int n2, int n3, int n4) throws IOException {
        this.hextile_bg = new Color(0);
        this.hextile_fg = new Color(0);
        int n5 = n2;
        while (n5 < n2 + n4) {
            int n6 = 16;
            if (n2 + n4 - n5 < 16) {
                n6 = n2 + n4 - n5;
            }
            int n7 = n;
            while (n7 < n + n3) {
                int n8 = 16;
                if (n + n3 - n7 < 16) {
                    n8 = n + n3 - n7;
                }
                this.handleHextileSubrect(n7, n5, n8, n6);
                n7 += 16;
            }
            this.scheduleRepaint(n, n2, n3, n4);
            n5 += 16;
        }
    }

    void handleHextileSubrect(int n, int n2, int n3, int n4) throws IOException {
        int n5 = this.rfb.is.readUnsignedByte();
        if (this.rfb.rec != null) {
            this.rfb.rec.writeByte(n5);
        }
        if ((n5 & 1) != 0) {
            this.handleRawRect(n, n2, n3, n4, false);
            return;
        }
        byte[] byArray = new byte[this.bytesPixel];
        if ((n5 & 2) != 0) {
            this.rfb.is.readFully(byArray);
            this.hextile_bg = this.bytesPixel == 1 ? this.colors[byArray[0] & 0xFF] : new Color(byArray[2] & 0xFF, byArray[1] & 0xFF, byArray[0] & 0xFF);
            if (this.rfb.rec != null) {
                this.rfb.rec.write(byArray);
            }
        }
        this.memGraphics.setColor(this.hextile_bg);
        this.memGraphics.fillRect(n, n2, n3, n4);
        if ((n5 & 4) != 0) {
            this.rfb.is.readFully(byArray);
            this.hextile_fg = this.bytesPixel == 1 ? this.colors[byArray[0] & 0xFF] : new Color(byArray[2] & 0xFF, byArray[1] & 0xFF, byArray[0] & 0xFF);
            if (this.rfb.rec != null) {
                this.rfb.rec.write(byArray);
            }
        }
        if ((n5 & 8) == 0) {
            return;
        }
        int n6 = this.rfb.is.readUnsignedByte();
        int n7 = n6 * 2;
        if ((n5 & 0x10) != 0) {
            n7 += n6 * this.bytesPixel;
        }
        byte[] byArray2 = new byte[n7];
        this.rfb.is.readFully(byArray2);
        if (this.rfb.rec != null) {
            this.rfb.rec.writeByte(n6);
            this.rfb.rec.write(byArray2);
        }
        int n8 = 0;
        if ((n5 & 0x10) == 0) {
            this.memGraphics.setColor(this.hextile_fg);
            int n9 = 0;
            while (n9 < n6) {
                int n10 = byArray2[n8++] & 0xFF;
                int n11 = byArray2[n8++] & 0xFF;
                int n12 = n + (n10 >> 4);
                int n13 = n2 + (n10 & 0xF);
                int n14 = (n11 >> 4) + 1;
                int n15 = (n11 & 0xF) + 1;
                this.memGraphics.fillRect(n12, n13, n14, n15);
                ++n9;
            }
        } else if (this.bytesPixel == 1) {
            int n16 = 0;
            while (n16 < n6) {
                this.hextile_fg = this.colors[byArray2[n8++] & 0xFF];
                int n17 = byArray2[n8++] & 0xFF;
                int n18 = byArray2[n8++] & 0xFF;
                int n19 = n + (n17 >> 4);
                int n20 = n2 + (n17 & 0xF);
                int n21 = (n18 >> 4) + 1;
                int n22 = (n18 & 0xF) + 1;
                this.memGraphics.setColor(this.hextile_fg);
                this.memGraphics.fillRect(n19, n20, n21, n22);
                ++n16;
            }
        } else {
            int n23 = 0;
            while (n23 < n6) {
                this.hextile_fg = new Color(byArray2[n8 + 2] & 0xFF, byArray2[n8 + 1] & 0xFF, byArray2[n8] & 0xFF);
                n8 += 4;
                int n24 = byArray2[n8++] & 0xFF;
                int n25 = byArray2[n8++] & 0xFF;
                int n26 = n + (n24 >> 4);
                int n27 = n2 + (n24 & 0xF);
                int n28 = (n25 >> 4) + 1;
                int n29 = (n25 & 0xF) + 1;
                this.memGraphics.setColor(this.hextile_fg);
                this.memGraphics.fillRect(n26, n27, n28, n29);
                ++n23;
            }
        }
    }

    void handleZlibRect(int n, int n2, int n3, int n4) throws Exception {
        int n5 = this.rfb.is.readInt();
        if (this.zlibBuf == null || this.zlibBufLen < n5) {
            this.zlibBufLen = n5 * 2;
            this.zlibBuf = new byte[this.zlibBufLen];
        }
        this.rfb.is.readFully(this.zlibBuf, 0, n5);
        if (this.rfb.rec != null && this.rfb.recordFromBeginning) {
            this.rfb.rec.writeIntBE(n5);
            this.rfb.rec.write(this.zlibBuf, 0, n5);
        }
        if (this.zlibInflater == null) {
            this.zlibInflater = new Inflater();
        }
        this.zlibInflater.setInput(this.zlibBuf, 0, n5);
        if (this.bytesPixel == 1) {
            int n6 = n2;
            while (n6 < n2 + n4) {
                this.zlibInflater.inflate(this.pixels8, n6 * this.rfb.framebufferWidth + n, n3);
                if (this.rfb.rec != null && !this.rfb.recordFromBeginning) {
                    this.rfb.rec.write(this.pixels8, n6 * this.rfb.framebufferWidth + n, n3);
                }
                ++n6;
            }
        } else {
            byte[] byArray = new byte[n3 * 4];
            int n7 = n2;
            while (n7 < n2 + n4) {
                this.zlibInflater.inflate(byArray);
                int n8 = n7 * this.rfb.framebufferWidth + n;
                int n9 = 0;
                while (n9 < n3) {
                    this.pixels24[n8 + n9] = (byArray[n9 * 4 + 2] & 0xFF) << 16 | (byArray[n9 * 4 + 1] & 0xFF) << 8 | byArray[n9 * 4] & 0xFF;
                    ++n9;
                }
                if (this.rfb.rec != null && !this.rfb.recordFromBeginning) {
                    this.rfb.rec.write(byArray);
                }
                ++n7;
            }
        }
        this.handleUpdatedPixels(n, n2, n3, n4);
        this.scheduleRepaint(n, n2, n3, n4);
    }

    /*
     * Unable to fully structure code
     */
    void handleTightRect(int var1_1, int var2_2, int var3_3, int var4_4) throws Exception {
        block73: {
            var5_5 = this.rfb.is.readUnsignedByte();
            if (this.rfb.rec == null) break block73;
            if (this.rfb.recordFromBeginning) ** GOTO lbl-1000
            if (var5_5 == 8 << 4) ** GOTO lbl-1000
            if (var5_5 == 9 << 4) lbl-1000:
            // 3 sources

            {
                this.rfb.rec.writeByte(var5_5);
            } else {
                this.rfb.rec.writeByte(var5_5 | 15);
            }
        }
        var6_6 = 0;
        while (var6_6 < 4) {
            if ((var5_5 & 1) != 0 && this.tightInflaters[var6_6] != null) {
                this.tightInflaters[var6_6] = null;
            }
            var5_5 >>= 1;
            ++var6_6;
        }
        if (var5_5 > 9) {
            throw new Exception("Incorrect tight subencoding: " + var5_5);
        }
        if (var5_5 == 8) {
            if (this.bytesPixel == 1) {
                var7_7 = this.rfb.is.readUnsignedByte();
                this.memGraphics.setColor(this.colors[var7_7]);
                if (this.rfb.rec != null) {
                    this.rfb.rec.writeByte(var7_7);
                }
            } else {
                var7_8 = new byte[3];
                this.rfb.is.readFully(var7_8);
                if (this.rfb.rec != null) {
                    this.rfb.rec.write(var7_8);
                }
                var8_11 = new Color(-16777216 | (var7_8[0] & 255) << 16 | (var7_8[1] & 255) << 8 | var7_8[2] & 255);
                this.memGraphics.setColor(var8_11);
            }
            this.memGraphics.fillRect(var1_1, var2_2, var3_3, var4_4);
            this.scheduleRepaint(var1_1, var2_2, var3_3, var4_4);
            return;
        }
        if (var5_5 == 9) {
            var7_9 = new byte[this.rfb.readCompactLen()];
            this.rfb.is.readFully(var7_9);
            if (this.rfb.rec != null) {
                if (!this.rfb.recordFromBeginning) {
                    this.rfb.recordCompactLen(var7_9.length);
                }
                this.rfb.rec.write(var7_9);
            }
            var8_12 = Toolkit.getDefaultToolkit().createImage(var7_9);
            var9_14 = this.jpegRect = new Rectangle(var1_1, var2_2, var3_3, var4_4);
            synchronized (var9_14) {
                Toolkit.getDefaultToolkit().prepareImage(var8_12, -1, -1, this);
                try {
                    this.jpegRect.wait(3000L);
                }
                catch (InterruptedException var10_16) {
                    throw new Exception("Interrupted while decoding JPEG image");
                }
            }
            this.jpegRect = null;
            return;
        }
        var7_10 = 0;
        var8_13 = var3_3;
        var9_15 = new byte[2];
        var10_17 = new int[256];
        var11_19 = false;
        if ((var5_5 & 4) != 0) {
            var12_20 = this.rfb.is.readUnsignedByte();
            if (this.rfb.rec != null) {
                this.rfb.rec.writeByte(var12_20);
            }
            if (var12_20 == 1) {
                var7_10 = this.rfb.is.readUnsignedByte() + 1;
                if (this.rfb.rec != null) {
                    this.rfb.rec.writeByte(var7_10 - 1);
                }
                if (this.bytesPixel == 1) {
                    if (var7_10 != 2) {
                        throw new Exception("Incorrect tight palette size: " + var7_10);
                    }
                    this.rfb.is.readFully(var9_15);
                    if (this.rfb.rec != null) {
                        this.rfb.rec.write(var9_15);
                    }
                } else {
                    var13_21 = new byte[var7_10 * 3];
                    this.rfb.is.readFully(var13_21);
                    if (this.rfb.rec != null) {
                        this.rfb.rec.write(var13_21);
                    }
                    var14_24 = 0;
                    while (var14_24 < var7_10) {
                        var10_17[var14_24] = (var13_21[var14_24 * 3] & 255) << 16 | (var13_21[var14_24 * 3 + 1] & 255) << 8 | var13_21[var14_24 * 3 + 2] & 255;
                        ++var14_24;
                    }
                }
                if (var7_10 == 2) {
                    var8_13 = (var3_3 + 7) / 8;
                }
            } else if (var12_20 == 2) {
                var11_19 = true;
            } else if (var12_20 != 0) {
                throw new Exception("Incorrect tight filter id: " + var12_20);
            }
        }
        if (var7_10 == 0 && this.bytesPixel == 4) {
            var8_13 *= 3;
        }
        var12_20 = var4_4 * var8_13;
        if (var12_20 < 12) {
            if (var7_10 != 0) {
                var13_21 = new byte[var12_20];
                this.rfb.is.readFully(var13_21);
                if (this.rfb.rec != null) {
                    this.rfb.rec.write(var13_21);
                }
                if (var7_10 == 2) {
                    if (this.bytesPixel == 1) {
                        this.decodeMonoData(var1_1, var2_2, var3_3, var4_4, var13_21, var9_15);
                    } else {
                        this.decodeMonoData(var1_1, var2_2, var3_3, var4_4, var13_21, var10_17);
                    }
                } else {
                    var14_24 = 0;
                    var15_26 = var2_2;
                    while (var15_26 < var2_2 + var4_4) {
                        var16_29 = var1_1;
                        while (var16_29 < var1_1 + var3_3) {
                            this.pixels24[var15_26 * this.rfb.framebufferWidth + var16_29] = var10_17[var13_21[var14_24++] & 255];
                            ++var16_29;
                        }
                        ++var15_26;
                    }
                }
            } else if (var11_19) {
                var13_21 = new byte[var3_3 * var4_4 * 3];
                this.rfb.is.readFully(var13_21);
                if (this.rfb.rec != null) {
                    this.rfb.rec.write(var13_21);
                }
                this.decodeGradientData(var1_1, var2_2, var3_3, var4_4, var13_21);
            } else if (this.bytesPixel == 1) {
                var13_22 = var2_2;
                while (var13_22 < var2_2 + var4_4) {
                    this.rfb.is.readFully(this.pixels8, var13_22 * this.rfb.framebufferWidth + var1_1, var3_3);
                    if (this.rfb.rec != null) {
                        this.rfb.rec.write(this.pixels8, var13_22 * this.rfb.framebufferWidth + var1_1, var3_3);
                    }
                    ++var13_22;
                }
            } else {
                var13_21 = new byte[var3_3 * 3];
                var16_30 = var2_2;
                while (var16_30 < var2_2 + var4_4) {
                    this.rfb.is.readFully(var13_21);
                    if (this.rfb.rec != null) {
                        this.rfb.rec.write(var13_21);
                    }
                    var15_27 = var16_30 * this.rfb.framebufferWidth + var1_1;
                    var14_24 = 0;
                    while (var14_24 < var3_3) {
                        this.pixels24[var15_27 + var14_24] = (var13_21[var14_24 * 3] & 255) << 16 | (var13_21[var14_24 * 3 + 1] & 255) << 8 | var13_21[var14_24 * 3 + 2] & 255;
                        ++var14_24;
                    }
                    ++var16_30;
                }
            }
        } else {
            var13_23 = this.rfb.readCompactLen();
            var14_25 = new byte[var13_23];
            this.rfb.is.readFully(var14_25);
            if (this.rfb.rec != null && this.rfb.recordFromBeginning) {
                this.rfb.rec.write(var14_25);
            }
            if (this.tightInflaters[var15_28 = var5_5 & 3] == null) {
                this.tightInflaters[var15_28] = new Inflater();
            }
            var16_31 = this.tightInflaters[var15_28];
            var16_31.setInput(var14_25);
            var17_32 = new byte[var12_20];
            var16_31.inflate(var17_32);
            if (this.rfb.rec != null && !this.rfb.recordFromBeginning) {
                this.rfb.recordCompressedData(var17_32);
            }
            if (var7_10 != 0) {
                if (var7_10 == 2) {
                    if (this.bytesPixel == 1) {
                        this.decodeMonoData(var1_1, var2_2, var3_3, var4_4, var17_32, var9_15);
                    } else {
                        this.decodeMonoData(var1_1, var2_2, var3_3, var4_4, var17_32, var10_17);
                    }
                } else {
                    var18_33 = 0;
                    var19_36 = var2_2;
                    while (var19_36 < var2_2 + var4_4) {
                        var20_39 = var1_1;
                        while (var20_39 < var1_1 + var3_3) {
                            this.pixels24[var19_36 * this.rfb.framebufferWidth + var20_39] = var10_17[var17_32[var18_33++] & 255];
                            ++var20_39;
                        }
                        ++var19_36;
                    }
                }
            } else if (var11_19) {
                this.decodeGradientData(var1_1, var2_2, var3_3, var4_4, var17_32);
            } else if (this.bytesPixel == 1) {
                var18_34 = var2_2 * this.rfb.framebufferWidth + var1_1;
                var19_37 = 0;
                while (var19_37 < var4_4) {
                    System.arraycopy(var17_32, var19_37 * var3_3, this.pixels8, var18_34, var3_3);
                    var18_34 += this.rfb.framebufferWidth;
                    ++var19_37;
                }
            } else {
                var18_35 = 0;
                var21_41 = 0;
                while (var21_41 < var4_4) {
                    var16_31.inflate(var17_32);
                    var19_38 = (var2_2 + var21_41) * this.rfb.framebufferWidth + var1_1;
                    var20_40 = 0;
                    while (var20_40 < var3_3) {
                        this.pixels24[var19_38 + var20_40] = (var17_32[var18_35] & 255) << 16 | (var17_32[var18_35 + 1] & 255) << 8 | var17_32[var18_35 + 2] & 255;
                        var18_35 += 3;
                        ++var20_40;
                    }
                    ++var21_41;
                }
            }
        }
        this.handleUpdatedPixels(var1_1, var2_2, var3_3, var4_4);
        this.scheduleRepaint(var1_1, var2_2, var3_3, var4_4);
    }

    void decodeMonoData(int n, int n2, int n3, int n4, byte[] byArray, byte[] byArray2) {
        int n5 = n2 * this.rfb.framebufferWidth + n;
        int n6 = (n3 + 7) / 8;
        int n7 = 0;
        while (n7 < n4) {
            int n8;
            int n9 = 0;
            while (n9 < n3 / 8) {
                byte by = byArray[n7 * n6 + n9];
                n8 = 7;
                while (n8 >= 0) {
                    this.pixels8[n5++] = byArray2[by >> n8 & 1];
                    --n8;
                }
                ++n9;
            }
            n8 = 7;
            while (n8 >= 8 - n3 % 8) {
                this.pixels8[n5++] = byArray2[byArray[n7 * n6 + n9] >> n8 & 1];
                --n8;
            }
            n5 += this.rfb.framebufferWidth - n3;
            ++n7;
        }
    }

    void decodeMonoData(int n, int n2, int n3, int n4, byte[] byArray, int[] nArray) {
        int n5 = n2 * this.rfb.framebufferWidth + n;
        int n6 = (n3 + 7) / 8;
        int n7 = 0;
        while (n7 < n4) {
            int n8;
            int n9 = 0;
            while (n9 < n3 / 8) {
                byte by = byArray[n7 * n6 + n9];
                n8 = 7;
                while (n8 >= 0) {
                    this.pixels24[n5++] = nArray[by >> n8 & 1];
                    --n8;
                }
                ++n9;
            }
            n8 = 7;
            while (n8 >= 8 - n3 % 8) {
                this.pixels24[n5++] = nArray[byArray[n7 * n6 + n9] >> n8 & 1];
                --n8;
            }
            n5 += this.rfb.framebufferWidth - n3;
            ++n7;
        }
    }

    void decodeGradientData(int n, int n2, int n3, int n4, byte[] byArray) {
        byte[] byArray2 = new byte[n3 * 3];
        byte[] byArray3 = new byte[n3 * 3];
        byte[] byArray4 = new byte[3];
        int[] nArray = new int[3];
        int n5 = n2 * this.rfb.framebufferWidth + n;
        int n6 = 0;
        while (n6 < n4) {
            int n7 = 0;
            while (n7 < 3) {
                byArray4[n7] = (byte)(byArray2[n7] + byArray[n6 * n3 * 3 + n7]);
                byArray3[n7] = byArray4[n7];
                ++n7;
            }
            this.pixels24[n5++] = (byArray4[0] & 0xFF) << 16 | (byArray4[1] & 0xFF) << 8 | byArray4[2] & 0xFF;
            int n8 = 1;
            while (n8 < n3) {
                n7 = 0;
                while (n7 < 3) {
                    nArray[n7] = (byArray2[n8 * 3 + n7] & 0xFF) + (byArray4[n7] & 0xFF) - (byArray2[(n8 - 1) * 3 + n7] & 0xFF);
                    if (nArray[n7] > 255) {
                        nArray[n7] = 255;
                    } else if (nArray[n7] < 0) {
                        nArray[n7] = 0;
                    }
                    byArray4[n7] = (byte)(nArray[n7] + byArray[(n6 * n3 + n8) * 3 + n7]);
                    byArray3[n8 * 3 + n7] = byArray4[n7];
                    ++n7;
                }
                this.pixels24[n5++] = (byArray4[0] & 0xFF) << 16 | (byArray4[1] & 0xFF) << 8 | byArray4[2] & 0xFF;
                ++n8;
            }
            System.arraycopy(byArray3, 0, byArray2, 0, n3 * 3);
            n5 += this.rfb.framebufferWidth - n3;
            ++n6;
        }
    }

    void handleUpdatedPixels(int n, int n2, int n3, int n4) {
        this.pixelsSource.newPixels(n, n2, n3, n4);
        this.memGraphics.setClip(n, n2, n3, n4);
        this.memGraphics.drawImage(this.rawPixelsImage, 0, 0, null);
        this.memGraphics.setClip(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight);
    }

    void scheduleRepaint(int n, int n2, int n3, int n4) {
        this.repaint(this.viewer.deferScreenUpdates, n, n2, n3, n4);
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.processLocalKeyEvent(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.processLocalKeyEvent(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.processLocalMouseEvent(mouseEvent, false);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.processLocalMouseEvent(mouseEvent, false);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.processLocalMouseEvent(mouseEvent, true);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.processLocalMouseEvent(mouseEvent, true);
    }

    public void processLocalKeyEvent(KeyEvent keyEvent) {
        if (this.viewer.rfb != null && this.rfb.inNormalProtocol) {
            if (!this.inputEnabled) {
                if ((keyEvent.getKeyChar() == 'r' || keyEvent.getKeyChar() == 'R') && keyEvent.getID() == 401) {
                    try {
                        this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight, false);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            } else {
                RfbProto rfbProto = this.rfb;
                synchronized (rfbProto) {
                    try {
                        this.rfb.writeKeyEvent(keyEvent);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    this.rfb.notify();
                }
            }
        }
        keyEvent.consume();
    }

    public void processLocalMouseEvent(MouseEvent mouseEvent, boolean bl) {
        if (this.viewer.rfb != null && this.rfb.inNormalProtocol) {
            if (bl) {
                this.softCursorMove(mouseEvent.getX(), mouseEvent.getY());
            }
            RfbProto rfbProto = this.rfb;
            synchronized (rfbProto) {
                try {
                    this.rfb.writePointerEvent(mouseEvent);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.rfb.notify();
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    synchronized void handleCursorShapeUpdate(int n, int n2, int n3, int n4, int n5) throws IOException {
        int n6 = (n4 + 7) / 8;
        int n7 = n6 * n5;
        this.softCursorFree();
        if (n4 * n5 == 0) {
            return;
        }
        if (this.viewer.options.ignoreCursorUpdates) {
            if (n == -240) {
                this.rfb.is.skipBytes(6 + n7 * 2);
            } else {
                this.rfb.is.skipBytes(n4 * n5 + n7);
            }
            return;
        }
        this.softCursorPixels = new int[n4 * n5];
        if (n == -240) {
            byte[] byArray = new byte[6];
            this.rfb.is.readFully(byArray);
            int[] nArray = new int[]{0xFF000000 | (byArray[3] & 0xFF) << 16 | (byArray[4] & 0xFF) << 8 | byArray[5] & 0xFF, 0xFF000000 | (byArray[0] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[2] & 0xFF};
            byte[] byArray2 = new byte[n7];
            this.rfb.is.readFully(byArray2);
            byte[] byArray3 = new byte[n7];
            this.rfb.is.readFully(byArray3);
            int n8 = 0;
            int n9 = 0;
            while (n9 < n5) {
                int n10;
                int n11;
                int n12 = 0;
                while (n12 < n4 / 8) {
                    byte by = byArray2[n9 * n6 + n12];
                    byte by2 = byArray3[n9 * n6 + n12];
                    n11 = 7;
                    while (n11 >= 0) {
                        n10 = (by2 >> n11 & 1) != 0 ? nArray[by >> n11 & 1] : 0;
                        this.softCursorPixels[n8++] = n10;
                        --n11;
                    }
                    ++n12;
                }
                n11 = 7;
                while (n11 >= 8 - n4 % 8) {
                    n10 = (byArray3[n9 * n6 + n12] >> n11 & 1) != 0 ? nArray[byArray2[n9 * n6 + n12] >> n11 & 1] : 0;
                    this.softCursorPixels[n8++] = n10;
                    --n11;
                }
                ++n9;
            }
        } else {
            byte[] byArray = new byte[n4 * n5 * this.bytesPixel];
            this.rfb.is.readFully(byArray);
            byte[] byArray4 = new byte[n7];
            this.rfb.is.readFully(byArray4);
            int n13 = 0;
            int n14 = 0;
            while (n14 < n5) {
                int n15;
                int n16;
                int n17 = 0;
                while (n17 < n4 / 8) {
                    byte by = byArray4[n14 * n6 + n17];
                    n16 = 7;
                    while (n16 >= 0) {
                        if ((by >> n16 & 1) != 0) {
                            if (this.bytesPixel == 1) {
                                n15 = 0;
                                switch (this.viewer.options.eightBitColors) {
                                    case 1: {
                                        n15 = this.cm8_256c.getRGB(byArray[n13]);
                                        break;
                                    }
                                    case 2: 
                                    case 4: {
                                        n15 = this.cm8_64c.getRGB(byArray[n13]);
                                        break;
                                    }
                                    case 3: 
                                    case 5: {
                                        n15 = this.cm8_8c.getRGB(byArray[n13]);
                                    }
                                }
                            } else {
                                n15 = 0xFF000000 | (byArray[n13 * 4 + 1] & 0xFF) << 16 | (byArray[n13 * 4 + 2] & 0xFF) << 8 | byArray[n13 * 4 + 3] & 0xFF;
                            }
                        } else {
                            n15 = 0;
                        }
                        this.softCursorPixels[n13++] = n15;
                        --n16;
                    }
                    ++n17;
                }
                n16 = 7;
                while (n16 >= 8 - n4 % 8) {
                    if ((byArray4[n14 * n6 + n17] >> n16 & 1) != 0) {
                        if (this.bytesPixel == 1) {
                            n15 = 0;
                            switch (this.viewer.options.eightBitColors) {
                                case 1: {
                                    n15 = this.cm8_256c.getRGB(byArray[n13]);
                                    break;
                                }
                                case 2: 
                                case 4: {
                                    n15 = this.cm8_64c.getRGB(byArray[n13]);
                                    break;
                                }
                                case 3: 
                                case 5: {
                                    n15 = this.cm8_8c.getRGB(byArray[n13]);
                                }
                            }
                        } else {
                            n15 = 0xFF000000 | (byArray[n13 * 4 + 1] & 0xFF) << 16 | (byArray[n13 * 4 + 2] & 0xFF) << 8 | byArray[n13 * 4 + 3] & 0xFF;
                        }
                    } else {
                        n15 = 0;
                    }
                    this.softCursorPixels[n13++] = n15;
                    --n16;
                }
                ++n14;
            }
        }
        this.softCursorSource = new MemoryImageSource(n4, n5, this.softCursorPixels, 0, n4);
        this.softCursor = this.createImage(this.softCursorSource);
        this.cursorWidth = n4;
        this.cursorHeight = n5;
        this.hotX = n2;
        this.hotY = n3;
        this.showSoftCursor = true;
        this.repaint(this.viewer.deferCursorUpdates, this.cursorX - this.hotX, this.cursorY - this.hotY, this.cursorWidth, this.cursorHeight);
    }

    synchronized void handleCursorPosUpdate(int n, int n2) {
        if (n >= this.rfb.framebufferWidth) {
            n = this.rfb.framebufferWidth - 1;
        }
        if (n2 >= this.rfb.framebufferHeight) {
            n2 = this.rfb.framebufferHeight - 1;
        }
        this.softCursorMove(n, n2);
    }

    synchronized void softCursorMove(int n, int n2) {
        if (this.showSoftCursor) {
            this.repaint(this.viewer.deferCursorUpdates, this.cursorX - this.hotX, this.cursorY - this.hotY, this.cursorWidth, this.cursorHeight);
            this.repaint(this.viewer.deferCursorUpdates, n - this.hotX, n2 - this.hotY, this.cursorWidth, this.cursorHeight);
        }
        this.cursorX = n;
        this.cursorY = n2;
    }

    synchronized void softCursorFree() {
        if (this.showSoftCursor) {
            this.showSoftCursor = false;
            this.softCursor = null;
            this.softCursorSource = null;
            this.softCursorPixels = null;
            this.repaint(this.viewer.deferCursorUpdates, this.cursorX - this.hotX, this.cursorY - this.hotY, this.cursorWidth, this.cursorHeight);
        }
    }
}

