#
##  Configuration for /usr/lib/cgi-bin/roundup.cgi
#

# Configuration can also be provided through the OS environment (or via
# the Apache "SetEnv" configuration directive). If the variables
# documented below are set, they _override_ any configuation defaults
# given in this file. 

# TRACKER_HOMES is a list of trackers, in the form
# "NAME=DIR<sep>NAME2=DIR2<sep>...", where <sep> is the directory path
# separator (";" on Windows, ":" on Unix). 

# Make sure the NAME part doesn't include any url-unsafe characters like 
# spaces, as these confuse the cookie handling in browsers like IE.

# ROUNDUP_LOG is the name of the logfile; if it's empty or does not exist,
# logging is turned off (unless you changed the default below). 

# ROUNDUP_DEBUG is a debug level, currently only 0 (OFF) and 1 (ON) are
# used in the code. Higher numbers means more debugging output. 

# This indicates where the Roundup tracker lives
TRACKER_HOMES = {
# you can add entries like
#  'demo': '/home/joe/roundup/trackers/demo',
#'mytracker': '/var/lib/roundup/trackers/mytracker',
}

# Where to log debugging information to. Use an instance of DevNull if you
# don't want to log anywhere.
class DevNull:
    def write(self, info):
        pass
    def close(self):
        pass
#LOG = open('/var/log/roundup.cgi.log', 'a')
LOG = DevNull()

